/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.junitee.anttask.JUnitEEResultFormatter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractResultFormatter
implements JUnitEEResultFormatter {
    private OutputStream out;
    private File outfile;
    private boolean filterTrace;
    private String extension;

    public boolean isFilterTrace() {
        return this.filterTrace;
    }

    public void setFilterTrace(boolean filterTrace) {
        this.filterTrace = filterTrace;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public void setOutfile(File file) {
        this.outfile = file;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public OutputStream getOutput(String testName) throws FileNotFoundException {
        if (this.out != null) {
            return this.out;
        }
        String fileName = this.outfile.getAbsolutePath() + testName + this.extension;
        this.out = new FileOutputStream(fileName);
        return this.out;
    }

    public void flush() throws IOException {
        this.out.flush();
        if (this.out != null && this.out != System.out && this.out != System.err) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out = null;
        }
    }

    protected String getTestName(Node testSuiteNode) {
        NamedNodeMap attributes = testSuiteNode.getAttributes();
        String name = attributes.getNamedItem("name").getNodeValue();
        String pkg = attributes.getNamedItem("package").getNodeValue();
        if (pkg != null && pkg.length() != 0) {
            return pkg + "." + name;
        }
        return name;
    }
}

